CONTAINER Dtachyonsettings
{
	NAME Dtachyonsettings;
	INCLUDE VPbase;

	SEPARATOR { LINE; }

	GROUP TACHYON_SETTINGSGROUP_BASIC
	{		
		GROUP TACHYON_SETTINGSGROUP_BASIC_GENERAL
		{
            COLUMNS 1; DEFAULT 1;
            ALIGN_LEFT;

			BOOL TACHYON_SETTINGS_GENERAL_DEFAULT_LIGHT { ALIGN_LEFT; }
			STATICTEXT { ALIGN_LEFT; NAME TACHYON_SETTINGS_GENERAL_STANDALONE_AUTOSTART_TITLE; }
			LONG TACHYON_SETTINGS_GENERAL_STANDALONE_AUTOSTART_ENABLED { ALIGN_LEFT; ANIM OFF; CYCLE { } }
            BOOL TACHYON_SETTINGS_GENERAL_STANDALONE_AUTOSTART_FOR_MATERIAL_ENABLED { ALIGN_LEFT; ANIM OFF; }
			STATICTEXT { ALIGN_LEFT; NAME TACHYON_SETTINGS_GENERAL_RENDER_RESOLUTION_OVERSCAN_TITLE; }
            REAL TACHYON_SETTINGS_GENERAL_RENDER_RESOLUTION_OVERSCAN_PERCENT_X { CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }
            REAL TACHYON_SETTINGS_GENERAL_RENDER_RESOLUTION_OVERSCAN_PERCENT_Y { CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }
		}

		GROUP TACHYON_SETTINGSGROUP_BASIC_SHADERS
		{
			COLUMNS 1; DEFAULT 1;

			GROUP
			{
				COLUMNS 1; DEFAULT 1;

				STATICTEXT { ALIGN_LEFT; NAME TACHYON_SETTINGS_SHADER_RENDER_RESOLUTIONS_TITLE; }

				LONG TACHYON_SETTINGS_SHADER_RENDER_RESOLUTION_LOW
				{
					CYCLE
					{
						TACHYON_SETTINGS_SHADER_RESOLUTION_128;
						TACHYON_SETTINGS_SHADER_RESOLUTION_256;
						TACHYON_SETTINGS_SHADER_RESOLUTION_512;
						TACHYON_SETTINGS_SHADER_RESOLUTION_1024;
						TACHYON_SETTINGS_SHADER_RESOLUTION_2048;
						TACHYON_SETTINGS_SHADER_RESOLUTION_4096;
					};
					ANIM OFF;
				}

				LONG TACHYON_SETTINGS_SHADER_RENDER_RESOLUTION_MEDIUM
				{
					CYCLE
					{
						TACHYON_SETTINGS_SHADER_RESOLUTION_128;
						TACHYON_SETTINGS_SHADER_RESOLUTION_256;
						TACHYON_SETTINGS_SHADER_RESOLUTION_512;
						TACHYON_SETTINGS_SHADER_RESOLUTION_1024;
						TACHYON_SETTINGS_SHADER_RESOLUTION_2048;
						TACHYON_SETTINGS_SHADER_RESOLUTION_4096;
					};
					ANIM OFF;
				}

				LONG TACHYON_SETTINGS_SHADER_RENDER_RESOLUTION_HIGH
				{
					CYCLE
					{
						TACHYON_SETTINGS_SHADER_RESOLUTION_128;
						TACHYON_SETTINGS_SHADER_RESOLUTION_256;
						TACHYON_SETTINGS_SHADER_RESOLUTION_512;
						TACHYON_SETTINGS_SHADER_RESOLUTION_1024;
						TACHYON_SETTINGS_SHADER_RESOLUTION_2048;
						TACHYON_SETTINGS_SHADER_RESOLUTION_4096;
					};
					ANIM OFF;
				}
			}

			SEPARATOR { LINE; } 

			GROUP
			{
				COLUMNS 1; DEFAULT 1;

				STATICTEXT { ALIGN_LEFT; NAME TACHYON_SETTINGS_SHADER_PREVIEW_RESOLUTIONS_TITLE; }

				LONG TACHYON_SETTINGS_SHADER_MATERIAL_PREVIEW_RESOLUTION
				{
					CYCLE
					{
						TACHYON_SETTINGS_SHADER_RESOLUTION_128;
						TACHYON_SETTINGS_SHADER_RESOLUTION_256;
						TACHYON_SETTINGS_SHADER_RESOLUTION_512;
					};
					ANIM OFF;
				}

				LONG TACHYON_SETTINGS_SHADER_LIVEMODE_RESOLUTION
				{
					CYCLE
					{
						TACHYON_SETTINGS_SHADER_RESOLUTION_128;
						TACHYON_SETTINGS_SHADER_RESOLUTION_256;
						TACHYON_SETTINGS_SHADER_RESOLUTION_512;
					};
					ANIM OFF;
				}
			}
		}

		GROUP TACHYON_SETTINGSGROUP_BASIC_AA
		{
			COLUMNS 1; DEFAULT 1;

			LONG TACHYON_SETTINGS_AA_MODE
			{
				CYCLE
				{
					TACHYON_SETTINGS_AA_MODE_NONE;
					TACHYON_SETTINGS_AA_MODE_FXAA;
				}
			}
			
			SEPARATOR { LINE; } 
			
			BOOL TACHYON_SETTINGS_SUPER_SAMPLING_ENABLE { }
			LONG TACHYON_SETTINGS_SUPER_SAMPLING_COUNT { CUSTOMGUI LONGSLIDER; MIN 2; MAX 64; STEP 1; MINSLIDER 2; MAXSLIDER 64; ANIM OFF;}
			REAL TACHYON_SETTINGS_SUPER_SAMPLING_FILTER_SIZE { MIN 0.1; MAX 2.0; STEP 0.1;  MINSLIDER 0.1; MAXSLIDER 2.0; CUSTOMGUI REALSLIDER; ANIM OFF; }
		}

		GROUP TACHYON_SETTINGSGROUP_BASIC_DISPLACEMENT
		{
			COLUMNS 1; DEFAULT 1;
			
			BOOL TACHYON_SETTINGS_DISPLACEMENT_ENABLE { ANIM OFF; }
			BOOL TACHYON_SETTINGS_DISPLACEMENT_LIMIT_STEPS { ANIM OFF; }
			LONG TACHYON_SETTINGS_DISPLACEMENT_MAX_STEPS { CUSTOMGUI LONGSLIDER; MIN 1; MAX 128; STEP 1; MINSLIDER 1; MAXSLIDER 128; ANIM OFF; }
		}
	}

	GROUP TACHYON_SETTINGSGROUP_ENVIRONMENT 
	{
		GROUP TACHYON_SETTINGSGROUP_ENVIRONMENT_BG
		{
			COLUMNS 1; DEFAULT 1;

			COLOR TACHYON_SETTINGS_BACKGROUND_COLOR { }
			COLOR TACHYON_SETTINGS_AMBIENT_LIGHT_COLOR { }
		}

		GROUP TACHYON_SETTINGSGROUP_ENVIRONMENT_MAP
		{
			COLUMNS 1; DEFAULT 1;

			TEXTURE TACHYON_SETTINGS_ENVIRONMENT_TEXTURE { }
			REAL TACHYON_SETTINGS_IBL_SPECULAR_EXPOSURE { CUSTOMGUI REALSLIDER; MIN 0.01; STEP 0.1; MINSLIDER 0.01; MAXSLIDER 10.0; SCALE_H; }
			
			REAL TACHYON_SETTINGS_ENVIRONMENT_AZIMUTHAL_ROTATION { STEP 1.0; CUSTOMGUI REALSLIDER; MINSLIDER -360.0; MAXSLIDER 360.0; UNIT DEGREE; }

			SEPARATOR { LINE; }

			BOOL TACHYON_SETTINGS_ENVIRONMENT_REPLACE_BACKGROUND { }
			REAL TACHYON_SETTINGS_ENVIRONMENT_BLUR_FACTOR { CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT;}	

			SEPARATOR { LINE; }

			BOOL TACHYON_SETTINGS_IBL_ENABLE {  }
			REAL TACHYON_SETTINGS_IBL_EXPOSURE { CUSTOMGUI REALSLIDER; MIN 0.01; STEP 0.1; MINSLIDER 0.01; MAXSLIDER 10.0; SCALE_H; DEFAULT 1.0; }
			REAL TACHYON_SETTINGS_IBL_OCCLUSION { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 1.0; MAX 100.0; MINSLIDER 0.0; MAXSLIDER 100.0; SCALE_H; DEFAULT 100.0; UNIT PERCENT; }
			LONG TACHYON_SETTINGS_IBL_SAMPLES  { CUSTOMGUI LONGSLIDER; MIN 5000; MAX 500000; STEP 100; MINSLIDER 5000; MAXSLIDER 500000; SCALE_H; DEFAULT 10000; }
		}
	}

	GROUP TACHYON_SETTINGSGROUP_VOLUMETRICS
	{
		GROUP
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_VOLUMETRICS_ENABLE { }

			//GROUP
			//{
			//	COLUMNS 3; DEFAULT 1;
			//	SCALE_H;

			//	LONG TACHYON_SETTINGS_VOLUMETRICS_RESOLUTION_X { MIN 4; MAX 64; }
			//	LONG TACHYON_SETTINGS_VOLUMETRICS_RESOLUTION_Y { MIN 4; MAX 64; }
			//	LONG TACHYON_SETTINGS_VOLUMETRICS_RESOLUTION_Z { MIN 4; MAX 64; }
			//}

			VECTOR TACHYON_SETTINGS_VOLUMETRICS_RESOLUTION_XYZ { ANIM OFF; MIN 4; MAX 64; STEP 1; }
			LONG TACHYON_SETTINGS_VOLUMETRICS_RESOLUTION_SCALE { ANIM OFF; CUSTOMGUI LONGSLIDER; MIN 1; MAX 10; }

			REAL TACHYON_SETTINGS_VOLUMETRICS_TEMPORAL_JITTER_RADIUS { CUSTOMGUI REALSLIDER; MIN 0.0; MAX 1.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; }

            REAL TACHYON_SETTINGS_VOLUMETRICS_DENSITY_SCALE { CUSTOMGUI REALSLIDER; MINSLIDER 0.1; MAXSLIDER 5.0; STEP 0.01; }
		}
    }

	GROUP TACHYON_SETTINGSGROUP_REFLECTANCE
	{
		BOOL TACHYON_SETTINGS_SSRR_ENABLED {}
		
		REAL TACHYON_SETTINGS_SSRR_ITERATIONS { CUSTOMGUI REALSLIDER; MIN 1; STEP 1; MINSLIDER 1; MAXSLIDER 1000; SCALE_H; DEFAULT 300; }
		REAL TACHYON_SETTINGS_SSRR_JITTER_FACTOR { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; SCALE_H; DEFAULT 1.0; }

		SEPARATOR { LINE; }

		REAL TACHYON_SETTINGS_SSRR_FADE_SCREEN_EDGE_START { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; SCALE_H; DEFAULT 0.2; }
		REAL TACHYON_SETTINGS_SSRR_FADE_SCREEN_EDGE_END { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; SCALE_H; DEFAULT 1.0; }

		REAL TACHYON_SETTINGS_SSRR_FADE_DISTANCE_START { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; SCALE_H; DEFAULT 0.0; }
		REAL TACHYON_SETTINGS_SSRR_FADE_DISTANCE_END { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; SCALE_H; DEFAULT 1.0; }
	}

	GROUP TACHYON_SETTINGSGROUP_SHADOWS
	{
		LONG TACHYON_SETTINGS_DEFAULT_SHADOW_MAP_SIZE
		{
			CYCLE
			{
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_256;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_512;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_1024;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_2048;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_4096;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_8192;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_16384;
			};
			ANIM OFF;
		}
		
		LONG TACHYON_SETTINGS_MAX_SHADOW_MAP_SIZE
		{
			CYCLE
			{
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_256;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_512;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_1024;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_2048;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_4096;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_8192;
				TACHYON_SETTINGS_SHADOW_MAP_SIZE_16384;
			};
			ANIM OFF;
		}

		BOOL TACHYON_SETTINGS_USE_MAX_SHADOW_MAP_SIZE
		{
			ANIM OFF;
		}
	}

	GROUP TACHYON_SETTINGSGROUP_EFFECTS
	{	
		GROUP TACHYON_SETTINGSGROUP_EFFECTS_MB
		{
			COLUMNS 1; DEFAULT 1;
		

			BOOL TACHYON_SETTINGS_MOTION_BLUR_ENABLE { }
			LONG TACHYON_SETTINGS_MOTION_BLUR_LOOPCOUNT { CUSTOMGUI LONGSLIDER; MIN 2; MAX 64; STEP 1; MINSLIDER 2; MAXSLIDER 64; SCALE_H; }
		}

		GROUP TACHYON_SETTINGSGROUP_EFFECTS_DOF
		{
			COLUMNS 1; DEFAULT 1;
		
			BOOL TACHYON_SETTINGS_DOF_ENABLE { }
			LONG TACHYON_SETTINGS_DOF_SAMPLE_COUNT { MIN 16; MAX 64; }
		}

		GROUP TACHYON_SETTINGSGROUP_EFFECTS_AO
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_SSAO_ENABLE { }

			LONG TACHYON_SETTINGS_SSAO_ALGORITHM
			{
				CYCLE
				{
					TACHYON_SETTINGS_SSAO_ALGORITHM_HEMISPHERE_SSAO;
					TACHYON_SETTINGS_SSAO_ALGORITHM_GTAO;
				};
				ANIM OFF;
			}

			REAL TACHYON_SETTINGS_SSAO_RADIUS { MIN 0.0; STEP 0.1; }
			REAL TACHYON_SETTINGS_GTAO_RADIUS_LIMIT { MIN 0.0; STEP 0.1; } // only visible for GTAO
			LONG TACHYON_SETTINGS_GTAO_HORIZON_SEARCH_STEPS { MIN 1; MAX 32; } // only visible for GTAO
			REAL TACHYON_SETTINGS_SSAO_POWER { MIN 0.0; MAX 10.0; STEP 0.01; }

            // SSAO params
			LONG TACHYON_SETTINGS_SSAO_SAMPLES { MIN 8; MAX 256; }
			REAL TACHYON_SETTINGS_SSAO_HEMISPHERE_OFFSET { MIN 0.0; STEP 0.01; }

            // GTAO params
			//REAL TACHYON_SETTINGS_GTAO_FALLOFF_START { MIN 0.01; MAX 20.0; STEP 0.01; } // disabled until evtl. more artistic control is needed
			//REAL TACHYON_SETTINGS_GTAO_FALLOFF_END { MIN 0.01; MAX 20.0; STEP 0.01; } // disabled until evtl. more artistic control is needed
			SEPARATOR { LINE; }
			LONG TACHYON_SETTINGS_GTAO_FILTER_PASSES { MIN 1; MAX 6; }
			BOOL TACHYON_SETTINGS_GTAO_TEMPORAL_FILTER_FOR_LIVE { }
            BOOL TACHYON_SETTINGS_GTAO_ENABLE_DEPTH_PEELS { }
            BOOL TACHYON_SETTINGS_GTAO_ENABLE_BACKFACE_PEELS { }
            LONG TACHYON_SETTINGS_GTAO_NUM_DEPTH_LAYERS { MIN 1; MAX 16; }
		}

		GROUP TACHYON_SETTINGSGROUP_EFFECTS_BLOOM
		{
			COLUMNS 1; DEFAULT 1;
			
			BOOL TACHYON_SETTINGS_BLOOM_ENABLE { }
			BOOL TACHYON_SETTINGS_BLOOM_FIREFLY_REDUCTION {}
			REAL TACHYON_SETTINGS_BLOOM_INTENSITY { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 100.0; }
			REAL TACHYON_SETTINGS_BLOOM_INNER_WEIGHT { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.1; MINSLIDER 0.0; MAXSLIDER 10.0; }
			REAL TACHYON_SETTINGS_BLOOM_OUTER_WEIGHT { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.01; MINSLIDER 0.0; MAXSLIDER 1.0; }
		}

		GROUP TACHYON_SETTINGSGROUP_FOG
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_FOG_ENABLE {}
			COLOR TACHYON_SETTINGS_FOG_COLOR {}
			LONG TACHYON_SETTINGS_FOG_FALLOFF_TYPE 
			{
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_SETTINGS_FOG_FALLOFF_TYPE_LINEAR;
					TACHYON_SETTINGS_FOG_FALLOFF_TYPE_EXPONENTIAL;
				};
			}
			REAL TACHYON_SETTINGS_FOG_DENSITY { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 0.001; MINSLIDER 0.0; MAXSLIDER 1.0; }
			REAL TACHYON_SETTINGS_FOG_DISTANCE { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 1000.0; }

			LONG TACHYON_SETTINGS_FOG_HEIGHT_FALLOFF
			{
				CUSTOMGUI QUICKTABRADIO;
				SCALE_H;
				ANIM OFF;

				CYCLE
				{
					TACHYON_SETTINGS_FOG_FALLOFF_TYPE_NONE;
					TACHYON_SETTINGS_FOG_FALLOFF_TYPE_LINEAR;
					TACHYON_SETTINGS_FOG_FALLOFF_TYPE_EXPONENTIAL;
				};
			}
			REAL TACHYON_SETTINGS_FOG_HEIGHT { CUSTOMGUI REALSLIDER; MIN 0.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 1000.0; }
			REAL TACHYON_SETTINGS_FOG_BACKGROUND_STRENGTH { CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }
		}
	}
	
	GROUP TACHYON_SETTINGSGROUP_TONEMAPPING
	{
		GROUP TACHYON_SETTINGSGROUP_TONEMAPPING_TONE
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_TONE_MAPPING_ENABLE { }
			
			LONG TACHYON_SETTINGS_TONE_MAPPING_MODE
			{
				CYCLE
				{
					TACHYON_SETTINGS_TONE_MAPPING_MODE_LINEAR;
					TACHYON_SETTINGS_TONE_MAPPING_MODE_EXPONENTIAL;
					TACHYON_SETTINGS_TONE_MAPPING_MODE_REINHARD;
				}
			}
			
			BOOL TACHYON_SETTINGS_TONE_MAPPING_COLORSPACE_HSV { }
			
			REAL TACHYON_SETTINGS_TONE_MAPPING_EXPOSURE { MIN 0; MAX 10; STEP 0.05; CUSTOMGUI REALSLIDER; }
			REAL TACHYON_SETTINGS_TONE_MAPPING_BLACK_POINT { MIN 0.0; MAX 1.0; STEP 0.01; CUSTOMGUI REALSLIDER; }
			REAL TACHYON_SETTINGS_TONE_MAPPING_WHITE_POINT { MIN 0.0; MAX 10.0; MINSLIDER 0.0; MAXSLIDER 10.0; STEP 0.01; CUSTOMGUI REALSLIDER;}
		}
	}

	GROUP TACHYON_SETTINGSGROUP_POSTPROCESS
	{
		GROUP TACHYON_SETTINGSGROUP_CHROMATIC_ABERRATION
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_CHROMATIC_ABERRATION_ENABLE { }
			LONG TACHYON_SETTINGS_CHROMATIC_ABERRATION_STRENGTH { CUSTOMGUI LONGSLIDER; MIN 1; MAX 40; STEP 1; MINSLIDER 1; MAXSLIDER 10; }
		}

		GROUP TACHYON_SETTINGSGROUP_VIGNETTE
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_VIGNETTE_ENABLE { }
			REAL TACHYON_SETTINGS_VIGNETTE_RADIUS   { CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }
			REAL TACHYON_SETTINGS_VIGNETTE_SOFTNESS { CUSTOMGUI REALSLIDER; MIN 1.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }
			REAL TACHYON_SETTINGS_VIGNETTE_STRENGTH { CUSTOMGUI REALSLIDER; MIN 0.0; MAX 100.0; STEP 1.0; MINSLIDER 0.0; MAXSLIDER 100.0; UNIT PERCENT; }
		}

		GROUP TACHYON_SETTINGSGROUP_GAMMA
		{
			COLUMNS 1; DEFAULT 1;

			LONG TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE
            {
				CYCLE
				{
					TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_DEFAULT;
					TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_SRGB;
					TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_LINEAR;
					TACHYON_SETTINGS_OUTPUT_COLOR_PROFILE_CUSTOM;
				}
            }
			REAL TACHYON_SETTINGS_OUTPUT_COLOR_GAMMA { MIN 0.0; STEP 0.01; }
		}
	}

	GROUP TACHYON_SETTINGSGROUP_MULTI_PASS_SETTINGS 
	{
		//BOOL TACHYON_SETTINGS_MULTI_PASS_ENABLE { }
		BOOL TACHYON_SETTINGS_MULTI_PASS_ANTI_ALIASING { }

		SEPARATOR { LINE; }

		GROUP TACHYON_SETTINGSGROUP_MULTI_PASS_MATTE
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_MULTI_PASS_OBJECT_ID { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_MATERIAL_ID { }
		}

		GROUP TACHYON_SETTINGSGROUP_MULTI_PASS_LIGHTING
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_MULTI_PASS_RGBA { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_DIFFUSE_IBL { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_DIFFUSE { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_SPECULAR { }
			
			BOOL TACHYON_SETTINGS_MULTI_PASS_REFLECTION { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_REFRACTION { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_AMBIENT_OCCLUSION { }
		}

		GROUP TACHYON_SETTINGSGROUP_MULTI_PASS_MATERIAL
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_MULTI_PASS_MATERIAL_DIFFUSE { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_MATERIAL_SPECULAR { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_MATERIAL_EMISSIVE { }
		}

		GROUP TACHYON_SETTINGSGROUP_MULTI_PASS_ADVANCED
		{
			COLUMNS 1; DEFAULT 1;

			BOOL TACHYON_SETTINGS_MULTI_PASS_MATERIAL_NORMAL { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_MATERIAL_UVW { }
			BOOL TACHYON_SETTINGS_MULTI_PASS_DEPTH { }
		}

		SEPARATOR { LINE; }
		STATICTEXT TACHYON_SETTINGS_MULTI_PASS_POSTEFFECT_NOTE { ANIM OFF; }
	}

	GROUP TACHYON_SETTINGSGROUP_DEVTOOLS
	{
	}
}
